﻿///
/// 基本的な型の宣言や定義を含む共通ヘッダファイル。
///

#if       !defined(INCLUDED_SZ_TYPES)
#define            INCLUDED_SZ_TYPES

/// stdint.h の有無に関わらず boost を利用。
#include  <boost/cstdint.hpp>

typedef boost::int8_t   s08;
typedef boost::uint8_t  u08;
typedef boost::int16_t  s16;
typedef boost::uint16_t u16;
typedef boost::int32_t  s32;
typedef boost::uint32_t u32;
typedef boost::int64_t  s64;
typedef boost::uint64_t u64;

#if       defined(SZ_64)

/// プラットフォーム依存の要素インデックス型。64 ビット環境ではレジスタに合わせて 64 ビットにしておく。
/// STL コンテナのインデックス型もプラットフォーム依存。
typedef u64 index_t;

#else  // defined(SZ_64)

/// プラットフォーム依存の要素インデックス型。32 ビット環境ではレジスタに合わせて 32 ビットにしておく。
/// STL コンテナのインデックス型もプラットフォーム依存。
typedef u32 index_t;

#endif // defined(SG_64)

/// 無効なインデックスを表す index_t 型定数値。
const index_t INVALID_T = index_t(~0);

#if       !defined(INCLUDED_STD_STRING)
#define            INCLUDED_STD_STRING
#include  <string>
#endif // !defined(INCLUDED_STD_STRING)

//
// Unicode ビルドしかできないが、一応デフォルトのキャラクタ型を隠蔽化しておく。
//

#if       defined(_UNICODE)

#define   SZLIMPL(x)    L ## x

/// 現在のビルド設定に合わせたデフォルトのキャラクタ型。
typedef   wchar_t       szchar;

/// 現在のビルド設定に合わせたデフォルトの文字列型。
typedef   std::wstring  szstring;

#else  // defined(_UNICODE)

#error    "Compilation error: MBCS build is not supported."

#endif // defined(_UNICODE)

/// 現在のビルド設定に合わせた文字列リテラル定義用マクロ。
#define   SZL(x)          SZLIMPL(x)

/// 現在のビルド設定に合わせた空文字列リテラル。
#define   SZL_EMPTY       SZL("")

#endif // !defined(INCLUDED_SZ_TYPES)
